# Terraform module for deploying VyOS on Azure

This Terraform module deploys a VyOS virtual router in Azure, configured within a virtual network with defined security groups and network interfaces.

## Prerequisites

Before applying this module, ensure you have:

- An active Azure subscription:
    ```sh
    az account set --subscription "<subscription ID or name>"
    ```

- Azure CLI installed. [Installation link](https://learn.microsoft.com/en-us/cli/azure/install-azure-cli)

- Logged in with Azure credentials via CLI:
    ```sh
    az version
    az login
    ```

- Azure Resource Group (RG) created:
    ```sh
    az group create --name demoResourceGroup --location westus
    az group list
    az group show --name exampleGroup
    ```

- Terraform installed. [Installation link](https://developer.hashicorp.com/terraform/tutorials/aws-get-started/install-cli)

## Usage

### Setup Variables

All variables needed for customization are defined in `variables.tf`. Adjust them according to your infrastructure requirements.

## How to Run the Module

Follow these steps to initialize, plan, apply, and manage your infrastructure with Terraform:

1. **Initialize the Module**
    ```sh
    terraform init
    ```

2. **Format Code**
   - Run `terraform fmt` to format the configuration files for consistency.
   
3. **Validate Configuration**
   - Execute `terraform validate` to check the syntax and verify configuration validity.

4. **Preview Infrastructure Changes**
    ```sh
    terraform plan
    ```

5. **Apply the Configuration**
    ```sh
    terraform apply
    ```
   - Confirm the execution when prompted to provision the infrastructure.

6. **View Outputs**
   - Run `terraform output` to view the management IP and credentials for the VyOS and Ubuntu instances.

7. **Destroy Infrastructure**
    ```sh
    terraform destroy
    ```
   - Confirm the execution when prompted to tear down the infrastructure.

### Management

For management, use the `vyos_public_ip`, `ubuntu_public_ip`, and credentials from `outputs`.

Sample command: 
```sh
ssh adminuser@<vyos_public_ip>
```
