resource "azurerm_virtual_network" "test_vnet" {
  name                = var.vnet_name
  address_space       = var.vnet_prefix
  location            = var.location
  resource_group_name = var.resource_group
  tags                = var.tags
}

resource "azurerm_subnet" "test_vnet_public" {
  name                 = var.public_subnet_name
  resource_group_name  = var.resource_group
  virtual_network_name = azurerm_virtual_network.test_vnet.name
  address_prefixes     = var.public_subnet_prefix
}

resource "azurerm_subnet" "test_vnet_private" {
  name                              = var.private_subnet_name
  resource_group_name               = var.resource_group
  virtual_network_name              = azurerm_virtual_network.test_vnet.name
  address_prefixes                  = var.private_subnet_prefix
  private_endpoint_network_policies = "RouteTableEnabled"
}

# Associate the NSG with the Public Subnet
resource "azurerm_subnet_network_security_group_association" "public_association" {
  subnet_id                 = azurerm_subnet.test_vnet_public.id
  network_security_group_id = azurerm_network_security_group.public_nsg.id
}

# Associate the NSG with Private Subnet
resource "azurerm_subnet_network_security_group_association" "private_association" {
  subnet_id                 = azurerm_subnet.test_vnet_private.id
  network_security_group_id = azurerm_network_security_group.private_nsg.id
}
